using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace CSharpBuch.Kap23
{
  public partial class RechnerForm:Form
  {
    private double zahl, ergebnis;
    private int operation;
    private bool neu, fertig;

    public RechnerForm()
    {
      InitializeComponent();
      zahl = 0;
      ergebnis = 0;
      lblAnzeige.Text = "";
      fertig = true;
      neu = true;
    }

    private void bnt1_Click(object sender, EventArgs e)
    {
      zahlAnhaengen(1);
    }

    private void btn2_Click(object sender, EventArgs e)
    {
      zahlAnhaengen(2);
    }

    private void btn3_Click(object sender, EventArgs e)
    {
      zahlAnhaengen(3);
    }

    private void bnt4_Click(object sender, EventArgs e)
    {
      zahlAnhaengen(4);
    }

    private void btn5_Click(object sender, EventArgs e)
    {
      zahlAnhaengen(5);
    }

    private void btn6_Click(object sender, EventArgs e)
    {
      zahlAnhaengen(6);
    }

    private void btn7_Click(object sender, EventArgs e)
    {
      zahlAnhaengen(7);
    }

    private void btn8_Click(object sender, EventArgs e)
    {
      zahlAnhaengen(8);
    }

    private void btn9_Click(object sender, EventArgs e)
    {
      zahlAnhaengen(9);
    }

    private void btn0_Click(object sender, EventArgs e)
    {
      zahlAnhaengen(0);
    }

    private void btnPunkt_Click(object sender, EventArgs e)
    {
      zahlAnhaengen(10);
    }

    private void zahlAnhaengen(int i)
    {
      if ((lblAnzeige.Text == "0") || fertig)
      {
        lblAnzeige.Text = "";
        fertig = false;
      }
      lblAnzeige.Text += "" + i;
      zahl = zahl * 10 + (int)i;
    }
    private void btnC_Click(object sender, EventArgs e)
    {
      zahl = 0;
      ergebnis = 0;
      lblAnzeige.Text = "0";
      neu = true;
      fertig = true;
    }

    private void btnRechne_Click(object sender, EventArgs e)
    {
      if (!fertig)
      {
        rechne();
        lblAnzeige.Text += "=" + ergebnis;
        zahl = 0;
        ergebnis = 0;
        neu = true;
        fertig = true;
      }
    }

    private void btnPlus_Click(object sender, EventArgs e)
    {
      rechne();
      lblAnzeige.Text += "+";
      operation = 1;
    }

    private void btnMinus_Click(object sender, EventArgs e)
    {
      rechne();
      lblAnzeige.Text += "-";
      operation = 2;
    }

    private void btnMal_Click(object sender, EventArgs e)
    {
      rechne();
      lblAnzeige.Text += "*";
      operation = 3;
    }

    private void btnDurch_Click(object sender, EventArgs e)
    {
      rechne();
      lblAnzeige.Text += "/";
      operation = 4;
    }

    private void btnModulo_Click(object sender, EventArgs e)
    {
      rechne();
      lblAnzeige.Text += "%";
      operation = 5;
    }

    private void rechne()
    {
      if (neu)
      {
        neu = false;
        ergebnis = zahl;
      }
      else
        switch (operation)
        {
          case 1:
            ergebnis += zahl;
            break;
          case 2:
            ergebnis -= zahl;
            break;
          case 3:
            ergebnis *= zahl;
            break;
          case 4:
            ergebnis /= zahl;
            break;
          case 5:
            ergebnis %= zahl;
            break;
        }
      zahl = 0;
    }

    private void btnQuadrat_Click(object sender, EventArgs e)
    {
      if (neu && !fertig)
      {
        ergebnis = zahl * zahl;
        lblAnzeige.Text += "=" + ergebnis;
        zahl = 0;
        ergebnis = 0;
        neu = true;
        fertig = true;
      }
      else
        MessageBox.Show("Dies Operation kann nur auf eine einzelne Zahl angewandt werden", "Achtung", MessageBoxButtons.OK, MessageBoxIcon.Warning);
    }

    private void btnWurzel_Click(object sender, EventArgs e)
    {
      if (neu && !fertig)
      {
        ergebnis = Math.Sqrt(zahl);
        lblAnzeige.Text += " SQRT =" + ergebnis;
        zahl = 0;
        ergebnis = 0;
        neu = true;
        fertig = true;
      }
      else
        MessageBox.Show("Dies Operation kann nur auf eine einzelne Zahl angewandt werden", "Achtung", MessageBoxButtons.OK, MessageBoxIcon.Warning);
    }

    private void formatToolStripMenuItem_Click(object sender, EventArgs e)
    {
      fontDialog1.Font = lblAnzeige.Font;
      if (fontDialog1.ShowDialog() == DialogResult.OK)
        lblAnzeige.Font = fontDialog1.Font;
    }

    private void btnSinus_Click(object sender, EventArgs e)
    {
      if (neu && !fertig)
      {
        ergebnis = Math.Sin(zahl);
        lblAnzeige.Text += " Sin =" + ergebnis;
        zahl = 0;
        ergebnis = 0;
        neu = true;
        fertig = true;
      }
      else
        MessageBox.Show("Dies Operation kann nur auf eine einzelne Zahl angewandt werden", "Achtung", MessageBoxButtons.OK, MessageBoxIcon.Warning);
    }

    private void RechnerForm_Resize(object sender, EventArgs e)
    {
      lblAnzeige.MinimumSize = new Size((this.Size.Width - 66), 22);
    }

    private void mnuAnzeigeUmschalten_TextChanged(object sender, EventArgs e)
    {
      if (((ToolStripComboBox)sender).SelectedIndex == 0)
      {
        btnSinus.Visible = false;
        btnModulo.Visible = false;
        btnWurzel.Visible = false;
        btnQuadrat.Visible = false;
      }
      else
      {
        btnSinus.Visible = true;
        btnModulo.Visible = true;
        btnWurzel.Visible = true;
        btnQuadrat.Visible = true;
      }
    }

    private void infoToolStripMenuItem_Click(object sender, EventArgs e)
    {
      MessageBox.Show("Taschenrechner mit Grundaufgaben und Zusatzfunktionen", "Info", MessageBoxButtons.OK, MessageBoxIcon.Information);
    }

    private void hilfeToolStripMenuItem1_Click(object sender, EventArgs e)
    {
      (new HifleForm()).Show();
    }

    private void mnuAnzeigeUmschalten_Click(object sender, EventArgs e)
    {

    }
  }
}